/************************************************************************************
* This file contains Platform specific implentations of BTA functions.
* For the Windows Simulator Platform.
*
* Author(s): Thomas O. Jensen
*
* (c) Copyright 2004, Freescale, Inc.  All rights reserved.
*
* Freescale Confidential Proprietary
* Digianswer Confidential
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale.
*
* Last Inspected:
* Last Tested:
************************************************************************************
*	 10/13/06	HS 	The mSETUP_PORT_TIMER micro replaced with mSETUP_PORT_DATAH
*					Header file renamed for HPRFGW
*					The NV_Data.h and PowerManager.h file commented-out
************************************************************************************/


/************************************************************************************
* Includes
************************************************************************************/
#include <nucleus.h>
#include "hprfgw_rfSlaveIntToRfApp.h"
#include "hprfgw_rfPortConfig.h"
#include "hprfgw_rfIrqControlLib.h"
#ifdef FREESCALE_802_15_4_STACK
#include "stdio.h"
#include "string.h"
#include "hprfgw_rfdesc.h"
#include "hprfgw_rfmc1319xReg.h"
#include "hprfgw_rfMc1319xDrv.h"
#include "hprfgw_rfMacPhyInit.h"
#endif //FREESCALE_802_15_4_STACK
#include "hprfgw_rfpowermanager.h"
#include "hprfgw_rfPlatformInit.h"
#include "hprfgw_rfSlaveIntToHost.h"
#include "hprfgw_rfSlaveIntToRfApp.h"
#include "ethernet.h"
#include "hardware.h"

volatile bool_t  bAttnIrq = FALSE;

extern void MemSmLib_SetCurrentChannel(void);
extern void AbelRegisterSetup(void);
extern void PhyPlmeSyncLossIndication(void);
extern void RestartRxOrTimeout(void);
extern void Phy_InitOnStartup(UINT16 calibration);	

#define ABEL_CCA_ENERGY_DETECT_THRESHOLD 0x2000 //MSB=CCA Energy detect threshold: abs(power in dBm)*2, 0x96=-75dBm, 0x82=-65dBm
#define ABEL_POWER_COMPENSATION_OFFSET   0x0074 //LSB=Power compensation Offset added to RSSI. Typical 0x74 FFJ/JK 13/01/04 (Abel 013)
#define ABEL_CLKO_FREQ 0x05 // LSB
#define ABEL_XTAL_TRIM (0x36 << 8) // MSB
#define ABEL_XTAL_BIAS_CURRENT 0x80 // LSB
#define ABEL_CHIP_RATE 0x00 // LSB


typedef struct Init_NV_RAM_Struct
{
	// Missing version strings
	uint8_t Target_Version[48];
	uint16_t Abel_Clock_Out_Setting;
	uint16_t Abel_HF_Calibration;
	uint8_t MAC_Address[8];
	uint8_t AntennaSelect;
	 uint8_t SleepModeEnable;
} Init_NV_RAM_Struct_t;


#define SPACE " "
// Initialized with default values
Init_NV_RAM_Struct_t NV_RAM0 =
{
	"Demo Appli Ver 1.00 Build: "__DATE__ SPACE __TIME__,
    (ABEL_XTAL_TRIM | ABEL_XTAL_BIAS_CURRENT | ABEL_CHIP_RATE | 6),
	(ABEL_CCA_ENERGY_DETECT_THRESHOLD | ABEL_POWER_COMPENSATION_OFFSET),
	0xaa,0xcd,0xcc,0xdd,0xff,0xdf,0xdd,0xaa,
	0x00,
	0x00,
};
Init_NV_RAM_Struct_t *NV_RAM_ptr = &NV_RAM0;

/*************************************************************************************
*************************************************************************************
* External platform references
*************************************************************************************
************************************************************************************/
extern void DisableInterrupt(BOOL hi, UINT32 mask);
extern void EnableInterrupt(BOOL hi, UINT32 mask);

#ifdef FREESCALE_802_15_4_STACK
	//	MC13192 PHY interrupt level and vector
	#define RFRECEIVE_MC13192PHY_INTLEV		       (MCF_INTC0_ICRn_IL(6)|MCF_INTC0_ICRn_IP(7))  // fixed because it's an Ext Interrupt
	#define RFRECEIVE_MC13192PHY_VECT			   70	
#endif

/*************************************************************************************
*************************************************************************************
* Private functions
*************************************************************************************
************************************************************************************/
//	RF receiver timer LISR/HISR parameters 
#define	PIT3_TIMER_VECT							103			//	PIT3 timer vector  
#define PIT3_TIMER_INTLEV           			(MCF_INTC0_ICRn_IL(3)|MCF_INTC0_ICRn_IP(1))  
#define RFREC_TIMER_HISR_PRIORITY       		1			//	timer hisr priority (0=highest priority, 2=lowest priority)
#define RFREC_TIMER_HISR_STACK_SIZE				8000		//	timer hisr stack size


typedef struct	{
    NU_HISR 	timerhisr;
	UINT8		timerhisrstack[RFREC_TIMER_HISR_STACK_SIZE];
}	RFRECTASKHISR;
RFRECTASKHISR RFRecTaskHisr;


// MNT - 5/7/2007 - Disable functions specific to the Freescale stack
#ifdef FREESCALE_802_15_4_STACK

/************************************************************************************
*************************************************************************************
* Public function(s)
*************************************************************************************
************************************************************************************/

/************************************************************************************
* Perform the complete GPIO port initialization
*
* Interface assumptions:
*
* Return value:
*   NONE
*
* Revision history:
*
*    Date    Author    Comments
*   ------   ------    --------
*   190505   JT        Created
*
************************************************************************************/
void PlatformPortInit(void)	{
	//	Platform ports default configuration/initialization
	QSPI_5271_Regs *qspi = get_qspi_ptr();
	GPIO_5271_Regs *gpio = get_gpio_ptr();
	
	//	QSPI initialization
	gpio->par_qspi		= 0x3F;	
	
	qspi->qspi_mode_reg = 0xC005;	
	qspi->qspi_wrap_reg = 0x1100;
	qspi->qspi_addr_reg = 0x20;
	qspi->qspi_data_reg = 0x8000;
	qspi->qspi_data_reg = 0x4000;
	qspi->qspi_int_reg  = 0xD00F;
	
	gpio->pddr_qspi		= 0x00; 	
	gpio->dscr_qspi		= 0x01;

#ifdef	TPS6_CLIENT_TEST
	//	Other IO initialization
	gpio->pddr_datal	= (gMC1319xRxTxMask_c|gMC1319xAttnMask_c|gMC1319xPAEnMask_c|gMC1319xAntSwTxEnMask_c|gMC1319xAntSwRxEnMask_c|gMC1319xResetMask_c);		
	//gpio->podr_datal	= (gMC1319xResetMask_c|gMC1319xAntSwRxEnMask_c|gMC1319xAntSwTxEnMask_c|gMC1319xAttnMask_c);
	gpio->podr_datal	= (gMC1319xAntSwRxEnMask_c|gMC1319xAntSwTxEnMask_c|gMC1319xAttnMask_c);
#else
	//	Other IO initialization
	gpio->pddr_datah	= (gMC1319xRxTxMask_c|gMC1319xAttnMask_c|gMC1319xPAEnMask_c|gMC1319xAntSwTxEnMask_c|gMC1319xAntSwRxEnMask_c|gMC1319xGPIO5Mask_c|gMC1319xGPIO6Mask_c|gMC1319xResetMask_c);		
	//gpio->podr_datah	= (gMC1319xResetMask_c|gMC1319xAntSwRxEnMask_c|gMC1319xAntSwTxEnMask_c|gMC1319xAttnMask_c);
	gpio->podr_datah	= (gMC1319xAntSwRxEnMask_c|gMC1319xAntSwTxEnMask_c|gMC1319xAttnMask_c);

	gpio->par_cs		= 0x00;
	gpio->pddr_cs	   &= ~(gMC1319xGPIO1Mask_c|gMC1319xGPIO2Mask_c|gMC1319xGPIO3Mask_c|gMC1319xGPIO4Mask_c); 	
#endif

#ifdef I_AM_A_SNIFFER
  TPM1SC = 0x0c; 	// Use BUSCLK and prescale with factor 16 (to get 1 us)
  TPM1C1SC = 0x04; 	// Disable interrupt, Input capture, Capture on rising edge
#endif I_AM_A_SNIFFER
}

/************************************************************************************
* Initialize platform specific stuff
* NVRAM, Bootloader, MC1319x driver etc.
*
* Interface assumptions:
*
*   NOTE!!! This First section of this function code is added to ensure that the symbols 
*   are included in the build. The linker will remove these symbols if not referenced.
*   Hope to find a better way 21.10.03 MVC 
*
* Return value:
*   NONE
*
* Revision history:
*
*    Date    Author    Comments
*   ------   ------    --------
*   030505   JT        Created
*	1100707  HS		   uid added as input parameter, NV_Data_Init() function call removed
*
************************************************************************************/
void Platform_Init(void)	{
	// Init MCU specifics: GPIO ports, SPI - and reset MC1319x
	PlatformPortInit();   // Initializes GPIO port settings.
	MC1319xDrv_Init();    // Init SPI for MC1319x driver
	MC1319xDrv_Reset();   // Reset MC1319x  
}


/************************************************************************************
* Initialize platform and stack. 
*
* This function is the main initialization procedure, which will be called from the 
* startup code of the project. 
* If the code is build as a stand-alone application, this function is
* called from main() below. 
*
* Interface assumptions:
*
* Return value:
*   NONE
*
* Revision history:
*
*    Date    Author    Comments
*   ------   ------    --------
*   030505   JT        Created
*
************************************************************************************/
void Init_802_15_4(UINT8 energythr, UINT8 PowerCompOffset, UINT8 *pUID)	{
	bool_t relaxedTiming;

	NV_RAM_ptr->Abel_HF_Calibration = (energythr<<8)+PowerCompOffset;
	memcpy (NV_RAM_ptr->MAC_Address, pUID, UID_MAX_SIZE);
	
	Platform_Init();    // Init platform 

	//Set to 1 if relaxed timing is required
	relaxedTiming = 0;

	MacPhyInit_Initialize(relaxedTiming, ((energythr<<8)|PowerCompOffset));    // Init 802.15.4 MAC/PHY stack
	MacPhyInit_WriteExtAddress (pUID);
}

void ResetRadio(void)
{  
  MC1319xDrv_WriteSpi(ABEL_reg0, 0x01);/*soft reset*/

  // wait the attn irq
  while (!bAttnIrq);    
  bAttnIrq = FALSE;

  Phy_InitOnStartup(NV_RAM_ptr->Abel_HF_Calibration); //set CCA threshold and offset
  MemSmLib_SetCurrentChannel(); //set to current channel
  PhyPlmeSyncLossIndication();  //send indication loss to MAC
  
}

#endif //if FREESCALE_802_15_4_STACK



/**
 *
 * \author      Hazrat Shah	
 *
 * \brief		This function initializes the RF receive timer but keep it disabled
 *
 * \detail		
 * \date        08/23/2006
 * \param	    None
 *
 * \return		None			
 *
 * \retval		
 */
void RFReceive_TimerInitialize (void)	{
	PIT_5271_Regs* timer = mcf5271_pit3_ptr();
   	INTCx_5271_Regs *intc0 = mcf5271_intc0_ptr();
	void (*old_lisr)(INT);
	UINT32 usec = 1500;

	//	Initialize and start the timer but, keep the timer interrupt disabled
	timer->modulus_reg = ((HwGetSystemClockHz()/8)/1000000L)*usec - 1; 
	timer->ctrl_status_reg = (MCF_PIT_PCSR_PRE(3)|(MCF_PIT_PCSR_OVW|MCF_PIT_PCSR_RLD|MCF_PIT_PCSR_EN|MCF_PIT_PCSR_PIE));
	
    if (NU_SUCCESS != NU_Register_LISR(PIT3_TIMER_VECT, RFReceive_Timer_LISR, &old_lisr))	{
    	RFIntHostApp.pF_SystemError (FATAL_RF_INIT);
    }

	if (NU_SUCCESS != NU_Create_HISR (&RFRecTaskHisr.timerhisr, "HRFREC", RFReceive_Timer_HISR, 
									  RFREC_TIMER_HISR_PRIORITY, (void*) &RFRecTaskHisr.timerhisrstack, 
									  (UINT32) sizeof(RFRecTaskHisr.timerhisrstack)))	{
		RFIntHostApp.pF_SystemError (FATAL_RF_INIT);
    }

	//	Set timer interrupt level	
	intc0->icr_pit3_int     =  PIT3_TIMER_INTLEV;
	//	Enable PIT2 timer vector interrupt 
    //EnableInterrupt(TRUE,  MCF_IMRH_PIT3_INT);
    //	Enable global vector interrupt
    // EnableInterrupt(FALSE, MCF_INTC0_IMRL_MASKALL); 
}  






/**
 *
 * \author      Hazrat Shah	
 *
 * \brief		This function is called by the RF receiver timer LISR interrupt.
 *
 * \detail		This function calls the mlm_Main() which is basically process the data/command
 *				messages which are pending in any of the MAC input queues. The function returns 
 *				TRUE it it has more messages to process then it should be called again immediatly.
 *				OthereiseFA
 *				queue/dequeuframes
 * 
 * \date        08/22/2006
 * \param	    None
 *
 * \return		None			
 *
 * \retval		
 */
void RFReceive_Timer_HISR(void)	{
	RFReceive_Timer_HISR_Function();
}



/**
 *
 * \author      Hazrat Shah	
 *
 * \brief		This function is called on RF receiver timer interrupt. It activtes the RF receive timer HISR
 *
 * \detail		
 * 
 * \date        08/22/2006
 * \param	    None
 *
 * \return		None			
 *
 * \retval		
 */
void RFReceive_Timer_LISR(int vector_num)	{
  	PIT_5271_Regs* timer = mcf5271_pit3_ptr();

	//	Aknowledge the pit timer	
	timer->ctrl_status_reg  |= MCF_PIT_PCSR_PIF;

	//	Start the RF receiver timer processing routine which calls the RF stack 
	NU_Activate_HISR (&RFRecTaskHisr.timerhisr);
}




/**
 *
 * \author      Hazrat Shah	
 *
 * \brief		This function disables the RF receiver timer interrupt	 			           
 *
 * \detail		
 * \date        08/23/2006
 *
 * \param	    None
 *
 * \return		UINT16 result 			
 *
 * \retval		SUCCESS/FAILURE 
 */
UINT16 RFReceive_DisableTimerInterrupt (void)	{
	UINT16 	result = SUCCESS;

#ifdef FREESCALE_802_15_4_STACK
	PIT_5271_Regs* timer = mcf5271_pit3_ptr();
  	int old_level;
	
	old_level = NU_Local_Control_Interrupts(NET_EthernetInterruptLevel);	
	//timer->ctrl_status_reg  &= ~(MCF_PIT_PCSR_PIE);
	DisableInterrupt(TRUE,  MCF_IMRH_PIT3_INT);
	NU_Local_Control_Interrupts(old_level);
#endif //#ifdef FREESCALE_802_15_4_STACK

	return (result);
}  

/**
 *
 * \author      Hazrat Shah	
 *
 * \brief		This function enables the RF receiver timer interrupt	 			           
 *
 * \detail		
 * \date        08/23/2006
 * \param	    None
 *
 * \return		UINT16 result 			
 *
 * \retval		SUCCESS/FAILURE 
 */
UINT16 RFReceive_EnableTimerInterrupt (void)	{
	UINT16 	result = SUCCESS;

	PIT_5271_Regs* timer = mcf5271_pit3_ptr();
  	
	//timer->ctrl_status_reg  |= MCF_PIT_PCSR_PIE;

	EnableInterrupt(TRUE,  MCF_IMRH_PIT3_INT);

	return (result);
}  





#ifdef FREESCALE_802_15_4_STACK
/**
 *
 * \author      Hazrat Shah	
 *
 * \brief		This is the MC13192 PHY IRQ6 interrupt.  
 *
 * \detail		
 * 
 * \date        08/22/2006
 * \param	    None
 *
 * \return		None			
 *
 * \retval		
 */
void RFReceive_MC13192PHY_LISR(int vector_num)	{
/*
	EPORT_5271_Regs* eport = mcf5271_eport_ptr();

	//	Acknowledge interrupt
	eport->eport_flags_reg = MCF_EPORT_EPFR_EPF6;

	//	Call the MC13192PHY service function
	MC1319xInterrupt();
*/
}





/**
 *
 * \author      Hazrat Shah	
 *
 * \brief		This function sets up the stack LISR interrupt, vector and levels   			           
 *
 * \detail		
 * \date        11/08/2006
 *
 * \param	    None
 *
 * \return		None			
 *
 * \retval		
 */
void RFReceive_StackInterruptConfig (void)	{
	INTCx_5271_Regs *intc0 = mcf5271_intc0_ptr();
/*
	void (*old_lisr)(INT);
	// Create LISR for MC13192 PHY chip at External interrupt IRQ6 
	if (NU_SUCCESS != NU_Register_LISR(RFRECEIVE_MC13192PHY_VECT, RFReceive_MC13192PHY_LISR, &old_lisr))	{
		RFIntHostApp.pF_SystemError (FATAL_RF_INIT);
	}
*/

	//	Set interrupt level	
	intc0->icr_ext_int6 =  RFRECEIVE_MC13192PHY_INTLEV;
	//	Enable vector interrupt 
	EnableInterrupt(FALSE,  MCF_IMRL_EXT_INT6);
	//	Enable global vector interrupt
	EnableInterrupt(FALSE, MCF_INTC0_IMRL_MASKALL); 
}
#endif //FREESCALE_802_15_4_STACK

UINT16	RFReceive_GetTimerValue (void)	{
	PIT_5271_Regs* timer = mcf5271_pit3_ptr();
	return (timer->count_reg);
}
